/******************************************************************************
 * Technical University of Darmstadt
 * Industrial Process and System Communication
 * Project: Discrete Fourier Transformation
 * Filename: ImageGrabber.java
 * Author: Gunter Weiss
 * Contents: Loads an image,
 * Last Changes: Gunter Weiss 25/4/97
 *****************************************************************************/

import java.awt.Panel;
import java.awt.Toolkit;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.net.URL;
import misc.Debug;

/******************************************************************************
* Class: ImageGrabber
* Description: Loads an image and returns it
******************************************************************************/

public class ImageGrabber {
  Image current = null;
  boolean applet;
  TcpStarter starter;

  public ImageGrabber( TcpStarter target, boolean theparent ){
    applet = theparent;
    starter = target;
  }

/******************************************************************************
* Method: giveImage
* Description: loads an image
* Parameters: the choosen picture-filepath
* Return Value: the Picture
******************************************************************************/
  public Image giveImage( String file ) {
    try {

      if ( !applet ) {
	file = "./" + file;
	current = Toolkit.getDefaultToolkit().getImage( file );

      } else {
	current = starter.parent.getImage( starter.parent.getDocumentBase(), file );

      }
    } catch( Exception e) { Debug.out("Error while loading an Image !"); }
    return current;
  }

}












